/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tiled.core.Map;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.ResizePanel;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class ResizeDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private final Map currentMap;
    private IntegerSpinner width;
    private IntegerSpinner height;
    private IntegerSpinner offsetX;
    private IntegerSpinner offsetY;
    private JButton bOk;
    private JButton bCancel;
    private ResizePanel orient;
    private static final String DIALOG_TITLE = Resources.getString("dialog.resizemap.title");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");
    private static final String OFFSET_TITLE = Resources.getString("dialog.resizemap.offset.title");
    private static final String X_LABEL = Resources.getString("dialog.resizemap.x.label");
    private static final String Y_LABEL = Resources.getString("dialog.resizemap.y.label");
    private static final String NEWSIZE_TITLE = Resources.getString("dialog.resizemap.newsize.title");
    private static final String WIDTH_LABEL = Resources.getString("dialog.resizemap.width.label");
    private static final String HEIGHT_LABEL = Resources.getString("dialog.resizemap.height.label");
    private static final String CURRENT_SIZE_TITLE = Resources.getString("dialog.resizemap.currentsize.title");

    public ResizeDialog(JFrame parent, MapEditor m) {
        super(parent, DIALOG_TITLE, true);
        this.currentMap = m.getCurrentMap();
        this.init();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void init() {
        this.bOk = new JButton(OK_BUTTON);
        this.bCancel = new JButton(CANCEL_BUTTON);
        this.width = new IntegerSpinner(this.currentMap.getWidth(), 1);
        this.height = new IntegerSpinner(this.currentMap.getHeight(), 1);
        this.offsetX = new IntegerSpinner();
        this.offsetY = new IntegerSpinner();
        this.offsetX.addChangeListener(this);
        this.offsetY.addChangeListener(this);
        this.orient = new ResizePanel(this.currentMap);
        this.orient.addPropertyChangeListener(this);
        VerticalStaticJPanel offsetPanel = new VerticalStaticJPanel();
        offsetPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(OFFSET_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        offsetPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 0, 5);
        offsetPanel.add((Component)new JLabel(X_LABEL), c);
        c.gridy = 1;
        offsetPanel.add((Component)new JLabel(Y_LABEL), c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        offsetPanel.add((Component)this.offsetX, c);
        c.gridy = 1;
        offsetPanel.add((Component)this.offsetY, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        offsetPanel.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.gridheight = 1;
        VerticalStaticJPanel newSizePanel = new VerticalStaticJPanel(new GridBagLayout());
        newSizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(NEWSIZE_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 0, 5);
        newSizePanel.add((Component)new JLabel(WIDTH_LABEL), c);
        c.gridy = 1;
        newSizePanel.add((Component)new JLabel(HEIGHT_LABEL), c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        newSizePanel.add((Component)this.width, c);
        c.gridy = 1;
        newSizePanel.add((Component)this.height, c);
        VerticalStaticJPanel origSizePanel = new VerticalStaticJPanel(new GridBagLayout());
        origSizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(CURRENT_SIZE_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        c = new GridBagConstraints();
        c.anchor = 13;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 5);
        origSizePanel.add((Component)new JLabel(WIDTH_LABEL), c);
        c.gridy = 1;
        origSizePanel.add((Component)new JLabel(HEIGHT_LABEL), c);
        c.anchor = 17;
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        origSizePanel.add((Component)new JLabel(String.valueOf(this.currentMap.getWidth())), c);
        c.gridy = 1;
        origSizePanel.add((Component)new JLabel(String.valueOf(this.currentMap.getHeight())), c);
        VerticalStaticJPanel sizePanels = new VerticalStaticJPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 0.0;
        sizePanels.add((Component)origSizePanel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        sizePanels.add((Component)newSizePanel, c);
        this.bOk.addActionListener(this);
        this.bCancel.addActionListener(this);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(this.bOk);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.bCancel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(sizePanels);
        mainPanel.add(offsetPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(Box.createGlue());
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.bOk);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.bOk) {
            int nwidth = this.width.intValue();
            int nheight = this.height.intValue();
            int dx = this.offsetX.intValue();
            int dy = this.offsetY.intValue();
            this.currentMap.resize(nwidth, nheight, dx, dy);
            this.dispose();
        } else if (src == this.bCancel) {
            this.dispose();
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        double zoom = this.orient.getZoom();
        if (evt.getPropertyName().equalsIgnoreCase("offsetX")) {
            int val = (Integer)evt.getNewValue();
            this.offsetX.setValue((int)((double)val / ((double)this.currentMap.getTileWidth() * zoom)));
        } else if (evt.getPropertyName().equalsIgnoreCase("offsetY")) {
            int val = (Integer)evt.getNewValue();
            this.offsetY.setValue((int)((double)val / ((double)this.currentMap.getTileHeight() * zoom)));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.offsetX || source == this.offsetY) {
            int dx = this.offsetX.intValue();
            int dy = this.offsetY.intValue();
            double zoom = this.orient.getZoom();
            this.orient.moveMap((int)((double)(dx * this.currentMap.getTileWidth()) * zoom), (int)((double)(dy * this.currentMap.getTileHeight()) * zoom));
        }
    }
}

